/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.ntutil.security.base;

import filenet.vw.ntutil.PEBytePointer;
import filenet.vw.ntutil.VWNTUTIL_DLL;
import filenet.vw.ntutil.security.base.IVWNTSSPIServer;
import filenet.vw.ntutil.security.base.NativeSSPIPackage;
import filenet.vw.ntutil.security.base.SSPISecHandle;
import filenet.vw.ntutil.trace;

public class SSPIClient {
    private IVWNTSSPIServer m_server = null;
    private SSPISecHandle m_credHandle = new SSPISecHandle();
    private SSPISecHandle m_secContext = new SSPISecHandle();
    private PEBytePointer m_outPtr = null;
    private PEBytePointer m_inPtr = null;
    private boolean m_contextEstablished = false;
    private boolean m_handleEstablished = false;
    private boolean m_done = false;
    private boolean m_terminated = false;

    public static native void initIDs();

    private native boolean acquireCredentialsHandle() throws Exception;

    private native boolean initializeSecurityContext(boolean var1) throws Exception;

    private native void terminateSession() throws Exception;

    public SSPIClient(IVWNTSSPIServer server) throws Exception {
        try {
            this.m_server = server;
            this.m_outPtr = new PEBytePointer(NativeSSPIPackage.getPackageBufSize());
            this.m_inPtr = new PEBytePointer(NativeSSPIPackage.getPackageBufSize());
            trace.println("SSPIClient ctor");
        }
        catch (Throwable t) {
            throw new Exception(t.getMessage());
        }
    }

    public boolean authenticate() throws Exception {
        if (this.m_terminated) {
            throw new Exception("SSPIClient: Client session already terminated.");
        }
        boolean firstTime = true;
        trace.println("authenticate(E)");
        try {
            if (this.acquireCredentialsHandle()) {
                while (this.initializeSecurityContext(firstTime)) {
                    byte[] m_outBuf = null;
                    byte[] m_inBuf = null;
                    m_outBuf = this.m_outPtr.getBytes();
                    m_inBuf = this.m_server.accept(m_outBuf);
                    this.m_inPtr.setBytes(m_inBuf);
                    m_inBuf = null;
                    m_outBuf = null;
                    firstTime = false;
                    if (!this.m_done) continue;
                }
            }
            trace.println("authenticate(X), done=" + new Boolean(this.m_done).toString());
            return this.m_done;
        }
        catch (Throwable t) {
            trace.println("authenticate(X), got exception! " + t.getMessage());
            this.terminate();
            throw new Exception(t.getMessage());
        }
    }

    public SSPISecHandle getServerContext() throws Exception {
        if (this.m_done) {
            return this.m_server.getContext();
        }
        throw new Exception("SSPIClient: Unable to get server context.");
    }

    public void terminate() throws Exception {
        try {
            if (!this.m_terminated) {
                this.m_terminated = true;
                this.terminateSession();
                this.m_server.terminate();
                this.m_outPtr.free();
                this.m_inPtr.free();
            }
        }
        catch (Throwable t) {
            throw new Exception(t.getMessage());
        }
    }

    static {
        if (VWNTUTIL_DLL.initLibrary()) {
            SSPIClient.initIDs();
        }
    }
}

